VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form FormAdo 
   Caption         =   "Test ADO"
   ClientHeight    =   6045
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   9975
   LinkTopic       =   "Form1"
   ScaleHeight     =   6045
   ScaleWidth      =   9975
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtTable 
      Enabled         =   0   'False
      Height          =   375
      Left            =   7560
      TabIndex        =   8
      Text            =   "Sample2"
      Top             =   240
      Width           =   2055
   End
   Begin VB.TextBox txtDSN 
      Height          =   375
      Left            =   2040
      TabIndex        =   5
      Top             =   240
      Width           =   4095
   End
   Begin VB.CommandButton cmdRsInfo 
      Caption         =   "Recordset In&fo"
      Height          =   495
      Left            =   5040
      TabIndex        =   4
      Top             =   5400
      Width           =   2295
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   495
      Left            =   7440
      TabIndex        =   3
      Top             =   5400
      Width           =   2295
   End
   Begin VB.CommandButton cmdClean 
      Caption         =   "Clea&n"
      Height          =   495
      Left            =   2640
      TabIndex        =   2
      Top             =   5400
      Width           =   2295
   End
   Begin MSFlexGridLib.MSFlexGrid MSHFlexGrid1 
      Height          =   4335
      Left            =   240
      TabIndex        =   1
      Top             =   840
      Width           =   9495
      _ExtentX        =   16748
      _ExtentY        =   7646
      _Version        =   393216
   End
   Begin VB.CommandButton cmdTestAdo 
      Caption         =   "&Read"
      Height          =   495
      Left            =   240
      TabIndex        =   0
      Top             =   5400
      Width           =   2295
   End
   Begin VB.Label lblTable 
      Caption         =   "Table:"
      Height          =   375
      Left            =   6960
      TabIndex        =   7
      Top             =   240
      Width           =   495
   End
   Begin VB.Label lblDSN 
      Caption         =   "Database name"
      Height          =   375
      Left            =   360
      TabIndex        =   6
      Top             =   240
      Width           =   1575
   End
End
Attribute VB_Name = "FormAdo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This example illustrates how to use ADO over MyOLEDB Provider
' to read data from the btrieve table and get information about recordset
' features.
' Application reads first 100 rows from the table.
'
Option Explicit

Dim cnn As ADODB.Connection
Dim rs As ADODB.Recordset

Private Const ulMaxNumOfRows As Integer = 100
Private ulNumOfRows As Integer

Private Sub CheckRowsetProperties()
    ' get information about recordset features
    blnAddNew = rs.Supports(adAddNew)
    blnApproxPosition = rs.Supports(adApproxPosition)
    blnBookmark = rs.Supports(adBookmark)
    blnDelete = rs.Supports(adDelete)
    blnFind = rs.Supports(adFind)
    blnHoldRecords = rs.Supports(adHoldRecords)
    blnMovePrevious = rs.Supports(adMovePrevious)
    blnNotify = rs.Supports(adNotify)
    blnResync = rs.Supports(adResync)
    blnUpdate = rs.Supports(adUpdate)
    blnUpdateBatch = rs.Supports(adUpdateBatch)
End Sub

Private Sub cmdClean_Click()
On Error GoTo cmdClean_Click_Error
   MSHFlexGrid1.Rows = 1

' disable recordset info
cmdRsInfo.Enabled = False

' quit
cmdClean_Click_Exit:
    Exit Sub
cmdClean_Click_Error:
    Resume cmdClean_Click_Exit
End Sub

Private Sub cmdExit_Click()
    End
End Sub

Private Sub cmdLocation_Click()
    frmLocation.Show 1
    
    ' What was the choice  ?
    If (bCancel = False) Then
        txtDSN.Text = sDDFPath
    End If
End Sub

Private Sub cmdRsInfo_Click()
    ' show recordset features
    Load frmRsInfo
    frmRsInfo.Show 1
End Sub

Private Sub cmdTestAdo_Click()
Dim b As Boolean
Dim Entry, i, Msg               ' Declare variables.

On Error GoTo cmdTestAdo_Click_Error

' clear variables
Set cnn = Nothing
Set rs = Nothing

' set variables
Set cnn = New ADODB.Connection
Set rs = New ADODB.Recordset

' Open Connection
On Error GoTo cmdTestAdo_Click_Connect_Error
cnn.Provider = "MySqlProv"
cnn.ConnectionString = txtDSN.Text
cnn.CommandTimeout = 10000
cnn.ConnectionTimeout = 10000
cnn.CursorLocation = adUseServer
cnn.Open

' Open Recordset
On Error GoTo cmdTestAdo_Click_RS_Error
rs.CacheSize = 100
rs.Open "Sample2", cnn, adOpenKeyset, adLockOptimistic, adCmdTableDirect

' check functionality
Call CheckRowsetProperties

' read data
On Error GoTo cmdTestAdo_Click_Data_Error
ulNumOfRows = 0
 For i = 1 To ulMaxNumOfRows
   ' Check whether end of table is reached
   If rs.BOF Or rs.EOF Then Exit For
   ' Create entry.
   Entry = i & Chr(9) & _
         rs.Bookmark & Chr(9) & _
         rs!ID & Chr(9) & _
         rs!FirstName & Chr(9) & _
         rs!LastName & Chr(9) & _
         rs!Street & Chr(9) & _
         rs!City & Chr(9) & _
         rs!State & Chr(9) & _
         rs!Zip & Chr(9) & _
         rs!Country & Chr(9) & _
         rs!Phone

    ' Add entry
    MSHFlexGrid1.AddItem Entry      ' Add entry.
   
    ' to next record
    rs.MoveNext
    ulNumOfRows = ulNumOfRows + 1
 Next i

' enable recordset info
On Error GoTo cmdTestAdo_Click_Error
cmdRsInfo.Enabled = True

' quit
cmdTestAdo_Click_Exit:
    ' try to close connection
    If (Not (cnn Is Nothing)) Then
        If (cnn.State <> adStateClosed) Then
            cnn.Close
        End If
    End If
    
    ' try to close recordset
    If (Not (rs Is Nothing)) Then
        If (rs.State <> adStateClosed) Then
            rs.Close
        End If
    End If
    
    Exit Sub

cmdTestAdo_Click_Error:
    Resume cmdTestAdo_Click_Exit

cmdTestAdo_Click_Connect_Error:
    If (txtDSN.Text <> "") Then
        MsgBox ("Error occured during opening connection! Check again the Data dictionary path!")
    End If
    Resume cmdTestAdo_Click_Exit
cmdTestAdo_Click_RS_Error:
    MsgBox ("Error occured during opening the recordset! Check that table " & txtTable & " is presented!")
    Resume cmdTestAdo_Click_Exit
cmdTestAdo_Click_Data_Error:
    MsgBox ("Error occured during data retrieving!")
    Resume cmdTestAdo_Click_Exit

End Sub

Private Sub Form_Load()
   ' disable recordset info
   cmdRsInfo.Enabled = False
   
   ' User can Resize
   MSHFlexGrid1.AllowUserResizing = flexResizeColumns
   ' Number of columns
   MSHFlexGrid1.Cols = 11
   MSHFlexGrid1.Rows = 1
   
   ' Title
   MSHFlexGrid1.Row = 0
   
   MSHFlexGrid1.Col = 1
   MSHFlexGrid1.Text = "Bmk"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "ID"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "FirstName"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "LastName"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "Street"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "City"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "State"
   
   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "Zip"

   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "Country"

   MSHFlexGrid1.Col = MSHFlexGrid1.Col + 1
   MSHFlexGrid1.Text = "Phone"
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set rs = Nothing
    Set cnn = Nothing

End Sub

